package test

import (
	"fmt"
	"github.com/gruntwork-io/terratest/modules/random"
	"github.com/gruntwork-io/terratest/modules/terraform"
	"testing"
)

func TestAsgExample(t *testing.T) {
	t.Parallel()

	terraformOptions := &terraform.Options{
		// Powinieneś uaktualnić tę względną ścieżkę dostępu,
    // aby prowadziła do katalogu examples!
		TerraformDir: "../examples/asg",
		Vars: map[string]interface{}{
			"cluster_name": fmt.Sprintf("test-%s", random.UniqueId()),
		},
	}

	defer terraform.Destroy(t, terraformOptions)
	terraform.InitAndApply(t, terraformOptions)
}
